
<div class="header">

    <?php if(request()->routeIs('karyawan.dashboard')): ?>

        <div class="header-left">
            <div class="header-logo">
                <img src="<?php echo e(asset('img/Logo.png')); ?>" alt="HARRIS Hotel Logo">
            </div>
        </div>

        <div class="header-right">
            
            <?php
                $unreadCount = auth()->user()->notifikasi()->forMode()->where('is_read', false)->count();
            ?>

            <a href="<?php echo e(route('notifikasi.index')); ?>"
               class="notification-btn <?php echo e(request()->routeIs('notifikasi.index') ? 'active' : ''); ?>">
                <i class="fas fa-bell"></i>
                <?php if($unreadCount > 0): ?>
                    <span class="notification-badge">
                        <?php echo e($unreadCount > 99 ? '99+' : $unreadCount); ?>

                    </span>
                <?php endif; ?>
            </a>

            <button type="button" class="profile-btn" onclick="openProfileModal()">
                <i class="fas fa-user-circle"></i>
            </button>
        </div>

    <?php else: ?>
        <a href="<?php echo e(route('karyawan.dashboard')); ?>" class="back-btn">
            <i class="fas fa-arrow-left"></i>
        </a>

        <h2 class="page-title">
            <?php echo $__env->yieldContent('title', 'Halaman'); ?>
        </h2>
    <?php endif; ?>

</div>

<?php echo $__env->make('karyawan.partials.profile-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
    /* Header Layout */
    .header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 1rem;
        /* background: rgb(255, 255, 255); */
        background: #354591;
        /* box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15); */
        position: relative;
        min-height: 70px;
    }

    .header-left {
        display: flex;
        align-items: center;
        gap: 1rem;
        flex: 1;
    }

    .header-logo img {
        height: 60px;
        width: auto;
    }

    .header-right {
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    /* Notification Button Style */
    .notification-btn {
        background: rgba(255, 255, 255, 0.289);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(0, 0, 0, 0.3);
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: rgb(255, 255, 255);
        font-size: 20px;
        cursor: pointer;
        transition: all 0.3s;
        position: relative;
        text-decoration: none;
    }

    .notification-btn:hover {
        background: rgba(12, 12, 12, 0.35);
        transform: scale(1.05);
        color: rgb(255, 193, 7);
    }

    .notification-btn.active {
        background: rgba(255, 193, 7, 0.2);
        color: rgb(255, 193, 7);
        border-color: rgb(255, 193, 7);
    }

    /* Notification Badge */
    .notification-badge {
        position: absolute;
        top: -4px;
        right: -4px;
        background: #ff4757;
        color: white;
        font-size: 10px;
        font-weight: 700;
        padding: 2px 5px;
        border-radius: 10px;
        min-width: 18px;
        height: 18px;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 8px rgba(255, 71, 87, 0.5);
        animation: pulse-badge 2s infinite;
    }

    @keyframes pulse-badge {
        0%, 100% {
            transform: scale(1);
        }
        50% {
            transform: scale(1.15);
        }
    }

    /* Profile Button Style */
    .profile-btn {
        background: rgba(255, 255, 255, 0.289);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(0, 0, 0, 0.3);
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: rgb(255, 255, 255);
        font-size: 24px;
        cursor: pointer;
        transition: all 0.3s;
    }

    .profile-btn:hover {
        background: rgba(0, 0, 0, 0.35);
        transform: scale(1.05);
    }

    .profile-btn:active {
        transform: scale(0.95);
    }

    /* Back Button & Page Title */
    .back-btn {
        background: rgba(154, 154, 154, 0.25);
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.3);
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: rgb(255, 255, 255);
        font-size: 18px;
        text-decoration: none;
        transition: all 0.3s;
    }

    .back-btn:hover {
        background: rgba(255, 255, 255, 0.35);
        transform: translateX(-3px);
    }

    .page-title {
        color: rgb(255, 255, 255);
        font-size: 1.25rem;
        font-weight: 700;
        margin: 0;
        flex: 1;
        text-align: center;
        padding-right: 10px;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .header {
            padding: 0.875rem;
        }

        .header-logo img {
            height: 50px;
        }

        .notification-btn,
        .profile-btn {
            width: 38px;
            height: 38px;
            font-size: 18px;
        }

        .notification-badge {
            font-size: 9px;
            min-width: 16px;
            height: 16px;
            top: -3px;
            right: -3px;
        }
    }

    @media (max-width: 480px) {
        .header-logo img {
            height: 45px;
        }

        .notification-btn,
        .profile-btn {
            width: 36px;
            height: 36px;
            font-size: 16px;
        }
    }
</style>

<script>
    // Profile Modal Functions
    function openProfileModal() {
        const modal = document.getElementById('profileModal');
        const overlay = document.getElementById('profileOverlay');

        if (modal && overlay) {
            overlay.classList.add('active');
            setTimeout(() => {
                modal.classList.add('active');
            }, 10);

            // Prevent body scroll
            document.body.style.overflow = 'hidden';
        }
    }

    function closeProfileModal() {
        const modal = document.getElementById('profileModal');
        const overlay = document.getElementById('profileOverlay');

        if (modal && overlay) {
            modal.classList.remove('active');
            setTimeout(() => {
                overlay.classList.remove('active');
            }, 300);

            // Restore body scroll
            document.body.style.overflow = '';
        }
    }

    // Close on overlay click
    document.addEventListener('DOMContentLoaded', function() {
        const overlay = document.getElementById('profileOverlay');
        if (overlay) {
            overlay.addEventListener('click', function(e) {
                if (e.target === overlay) {
                    closeProfileModal();
                }
            });
        }

        // Swipe down to close
        let touchStartY = 0;
        let touchEndY = 0;

        const modal = document.getElementById('profileModal');
        if (modal) {
            modal.addEventListener('touchstart', function(e) {
                touchStartY = e.touches[0].clientY;
            });

            modal.addEventListener('touchend', function(e) {
                touchEndY = e.changedTouches[0].clientY;

                // Swipe down more than 100px to close
                if (touchEndY - touchStartY > 100) {
                    closeProfileModal();
                }
            });
        }
    });
</script>
<?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/karyawan/partials/header.blade.php ENDPATH**/ ?>